/*****************************************************************************
*  LPC54xx SCT repetitive program for LPCXpresso
*
*  1. Use SCT timer to generate a 10 msec timer tick (interrupt driven).
*  2. Toggle P1_0 (red LED on LPCXpresso board) every 200 msec
*****************************************************************************/

#include "board.h"


/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
extern void SCT_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/


void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                   							// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, 	SCT_CONFIG_32BIT_COUNTER  |						// unified timers,
                              SCT_CONFIG_AUTOLIMIT_L    );						// auto limit

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0,	(SystemCoreClock/100) - 1);	//match 0 @ 100 Hz = 10 msec
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, (SystemCoreClock/100) - 1);


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_ALL_STATES);	 			// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, SCT_COMBMODE_MATCH);			// match 0 only condition

	Chip_SCT_EnableEventInt(LPC_SCT,SCT_EVT_0);									// event 0 generates an interrupt

    NVIC_EnableIRQ(SCT0_IRQn);                             						// enable SCT2 interrupt

    Chip_SCT_ClearControl(LPC_SCT,SCT_CTRL_HALT_L);								// start timer

}



void SCT0_IRQHandler(void)										// SCT Interrupt Handler (10 msec)
{
	 static uint8_t cnt = 0;

	    if (++cnt > 19)                                			// 20 * 10 msec = 200 msec
	    {
	        cnt = 0;
	        Chip_GPIO_SetPinToggle(LPC_GPIO , 1, 0); 			// toggle pin P1_0
	    }
	    Chip_SCT_SetEventFlag(LPC_SCT,SCT_EVT_0);  				// clear event 0 flag
}


int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();

	Chip_Clock_EnablePeriphClock(SYSCON_CLOCK_GPIO1 );		// enable GPIO1 clock

	Chip_GPIO_SetPinDIR(LPC_GPIO, 1, 0, true);				// configure P1_0 (red LED) as output

	SCT_Init();											    // Initialize SCT

	while (1)                                         		// loop forever
	{
		__WFI();
	}
}
